<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Capturando os dados do formulário
    $data = [
        "contatoNomeCompleto" => $_POST['contatoNomeCompleto'] ?? '',
        "contatoEmail" => $_POST['contatoEmail'] ?? "",
        "contatoTelefone" => $_POST['contatoTelefone'] ?? '',
        "produtoId" => $_POST['produtoId'] ?? null,
        "tipoResidencia" => $_POST['tipoResidencia'] ?? null,
        "qtdQuartos" => $_POST['qtdQuartos'] ?? null,
        "tipoVisto" => $_POST['tipoVisto'] ?? null,
        "previsaoMudanca" => $_POST['previsaoMudanca'] ?? null,
        "enderecoOrigem" => $_POST['enderecoOrigem'] ?? null,
        "enderecoDestino" => $_POST['enderecoDestino'] ?? null,
        "localAtual" => $_POST['localAtual'] ?? null,
        "prazo" => $_POST['prazo'] ?? null,
    ];

    // Convertendo os dados para JSON
    $jsonData = json_encode($data);

    // URL da API
    $url = 'https://onemoving.us/api/register_new_lead';

    // Inicializando o cURL
    $ch = curl_init($url);

    // Configurando o cURL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);

    // Executando a requisição
    $response = curl_exec($ch);

    // Fechando o cURL
    curl_close($ch);

    $page = [
        1=> 'mudanca-internacional',
        2=> 'mudanca-nacional',
        3=> 'armazenagem',
        4=> 'pets',
        5=> 'obras-de-arte',
    ];

    if (isset($_POST['produtoId'], $page[$_POST['produtoId']])) {
        $redirectUrl = 'https://onemoving.us/novo/' . $page[$_POST['produtoId']] . '?msg=true';
        header('Location: ' . $redirectUrl);
        exit;
    } else {
        echo 'Produto inválido.';
        exit;
    }
}
?>